/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.util.Comparators;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;

public class RebuildType
implements Propertized {
    private final String name;
    private final long time;
    private final Bom bom;
    private final PropertySupport propertySupport;
    private static Comparator<RebuildType> nameCompartor;
    private static Comparator<RebuildType> fullCompartor;

    public RebuildType(String name, long time, Bom bom) {
        Preconditions.checkNotNull(name, "RebuildType.name must not be null.");
        Preconditions.checkArgument(time > 0L, "RebuildType.time must be positive long.");
        this.name = name;
        this.time = time;
        this.bom = bom == null ? new Bom(Collections.emptyList()) : bom;
        this.propertySupport = new PropertySupport();
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public Bom getBom() {
        return this.bom;
    }

    public RebuildDivisibility getDivisibility() {
        return RebuildDivisibility.DIVISIBLE;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }

    public static Comparator<RebuildType> nameComparator() {
        if (nameCompartor == null) {
            nameCompartor = Ordering.from(new Comparator<RebuildType>(){

                @Override
                public int compare(RebuildType rt1, RebuildType rt2) {
                    return rt1.getName().compareTo(rt2.getName());
                }
            }).nullsLast();
        }
        return nameCompartor;
    }

    public static Comparator<RebuildType> fullComparator() {
        if (fullCompartor == null) {
            fullCompartor = Ordering.from(new Comparator<RebuildType>(){
                final Comparator<Bom> bomComparator = Bom.fullComparator();

                @Override
                public int compare(RebuildType rt1, RebuildType rt2) {
                    int res = rt1.getName().compareTo(rt2.getName());
                    if (res == 0 && (res = Comparators.compare(rt1.getTime(), rt2.getTime())) == 0) {
                        res = this.bomComparator.compare(rt1.getBom(), rt2.getBom());
                    }
                    return res;
                }
            }).nullsLast();
        }
        return fullCompartor;
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }

    public static enum RebuildDivisibility {
        INDIVISIBLE,
        DIVISIBLE,
        OFFLINE_TRANSPARENT;

    }
}

